%This program runs K = 1000 experiments under the baseline parameters, and
%then tests whether the distribution of ask prices at time t and at time T
%are different, for t = 500000, 700000, and 900000. These results are
%reported in Footnote 21 in the paper.

clear

% record running time
% when producing the data the running time was 1340 seconds
tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.  
alpha=0.01;             %alpha  is the learning rate.
beta=0.00008;           %beta   is the exploration decay rate.      
N = 2;                  %N is the number of AMMs.

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l=5;

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

grid_middle = 8;
grid_size= 69;  
tick= 0.1;      

% set random seed to ensure replicability
rng(1)

% Parallel computing initialization
% Can be commented out to run without parallelization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

%Call the function simulation_rep to run K experiments
[T_episodes]=simulation_rep(alpha,beta,T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,N,K);
%T_episodes is a K x 4 matrix reporting the best ask a_{k,t} in experiment
%k (in rows) and at time t \in \{500000, 700000, 900000, 1000000\} (in
%colums).

%Save the output in the subfolder "Data"
writematrix(T_episodes,'Data/T_episodes.txt');

toc